/************************************************************************
 * FILE:         CAmControlCvm.h
 * PROJECT:      G3g
 * SW-COMPONENT: Genivi Audio Manager Controller Plugin
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Class to handle System voltage level handling.
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2014 RBEI
 * HISTORY:
 * Date        | Author                 | Modification
 * 26.02.2014  | RBEI/ECV Ranjit Susal  | initial version
 *
 *************************************************************************/

#ifndef __CAM_CONTROL_CVM_H
#define __CAM_CONTROL_CVM_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include "IAmControlReceiverShadow.h"
class CAmControlSenderBase;


//Class CAmControlCvm
//Class to handle System voltage level handling.
#define GAM_PERMANENT_HIGH_VOLTAGE_START 20
#define GAM_PERMANENT_CRITICAL_HIGH_VOLTAGE_START 21

class CAmControlCvm
{
private:

  CAmControlSenderBase* m_poControlSenderBase;
  am::IAmControlReceiverShadow*  m_poControlReceiverShadow;

  OSAL_tIODescriptor    m_IODeviceVoltDescr;
  OSAL_tEventHandle     m_EventHandle;
  OSAL_tThreadID        m_ThreadIdCvmEvent;
  tU32                  m_u32ClientId;
  tU32                  m_u32PreviousSystemVoltage;

  static void vCamCCvmWorkerThread(tVoid *pvArg);

public:
  CAmControlCvm(tVoid);
  CAmControlCvm(CAmControlSenderBase*,am::IAmControlReceiverShadow* pControlReceiver);
  ~CAmControlCvm();

private :
  tS32 s32GetSystemVoltageHistory(DEV_VOLT_trSystemVoltageHistory &);
  void vStartVoltageMonitoring();
  void vSystemVoltageNotification();

  void vPrevVoltStateOperating(const DEV_VOLT_trSystemVoltageHistory &,const tU32 &);
  void vPrevVoltStateLow(const DEV_VOLT_trSystemVoltageHistory &,const tU32 &);
  void vPrevVoltStateCriticalLow(const tU32 &);
  void vCurrVoltStateOperating();
  void vCurrVoltStateHigh();
  void vCurrVoltStateCriticalHigh();
  void vNotifyCvmEvent(const tU32 &);

};


#endif // __CAM_CONTROL_CVM_H
